from flask import Flask, render_template, request
from flask_sqlalchemy import SQLAlchemy

app = Flask(__name__)
app.config['SQLALCHEMY_DATABASE_URI'] = 'sqlite:///users.db'
db = SQLAlchemy(app)

# User model
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password = db.Column(db.String, nullable=False)
    name = db.Column(db.String, nullable=False)
    email = db.Column(db.String, unique=True, nullable=False)

# Home page (login page)
@app.route('/', methods=['GET'])
def home_get():
    return render_template('login.html', error=None)

@app.route('/', methods=['POST'])
def home_post():
    
    # TODO: Complete this function

    return render_template('login.html', error="Invalid username or password")


app.run(debug=True, reloader_type='stat', port=5000)

