import os
from flask import Flask, render_template, request, redirect, url_for, session
from flask_sqlalchemy import SQLAlchemy

db_filename = "users.db"
db_path = f"instance/{db_filename}"

app = Flask(__name__)
app.config['SQLALCHEMY_DATABASE_URI'] = f'sqlite:///{db_filename}'
db = SQLAlchemy(app)

# User model
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password = db.Column(db.String, nullable=False)
    name = db.Column(db.String, nullable=False)
    email = db.Column(db.String, unique=True, nullable=False)

# Delete existing database file
if os.path.exists(db_path):
    os.remove(db_path)  
    print(f"Deleted existing database file: '{db_path}'")

# Create the database and a default user
with app.app_context():
    db.create_all()
    print(f"Successfully created a new database: '{db_path}'")
    
    if not User.query.first():  # If no users exist, create a default user
        user = User(username="admin", password="password123", name="Admin User", email="admin@example.com")
        db.session.add(user)
        db.session.commit()
        print("Default user added -> Username: 'admin', Password: 'password123'")

