import hashlib
from flask import Flask, render_template, request
from flask_sqlalchemy import SQLAlchemy

app = Flask(__name__)
app.config['SECRET_KEY'] = 'supersecretkey'
app.config['SQLALCHEMY_DATABASE_URI'] = 'sqlite:///users.db'
db = SQLAlchemy(app)

# User model
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password_hash = db.Column(db.String, nullable=False)  # Hashed password
    salt = db.Column(db.String, nullable=False)  # Store salt separately
    name = db.Column(db.String, nullable=False)
    email = db.Column(db.String, unique=True, nullable=False)

# Function to hash password with salt
def hash_password(password, salt):
    return hashlib.sha256(salt.encode() + password.encode()).hexdigest()

# Home page (login page)
@app.route('/', methods=['GET', ])
def home_get():
    return render_template('login.html', error=None)

# Home page (login page)
@app.route('/', methods=['POST'])
def home_post():
    
    # TODO: Complete this function
    
    return render_template('login.html', error="Invalid username or password")


app.run(debug=True, reloader_type='stat', port=5000)

