import os
import hashlib
from flask import Flask, render_template, request, redirect, url_for, session
from flask_sqlalchemy import SQLAlchemy

db_filename = "users.db"
db_path = f"instance/{db_filename}"

app = Flask(__name__)
app.config['SECRET_KEY'] = 'supersecretkey'
app.config['SQLALCHEMY_DATABASE_URI'] = 'sqlite:///users.db'
db = SQLAlchemy(app)

# User model
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password_hash = db.Column(db.String, nullable=False)  # Hashed password
    salt = db.Column(db.String, nullable=False)  # Store salt separately
    name = db.Column(db.String, nullable=False)
    email = db.Column(db.String, unique=True, nullable=False)

# Function to hash password with salt
def hash_password(password, salt):
    return hashlib.sha256(salt.encode() + password.encode()).hexdigest()


# Delete existing database file
if os.path.exists(db_path):
    os.remove(db_path)  
    print(f"Deleted existing database file: '{db_path}'")

# Create the database and a default user
with app.app_context():
    db.create_all()
    print(f"Successfully created a new database: '{db_path}'")
    
    admin_user = User.query.filter_by(username="admin").first()
    
    if not admin_user:  # If admin user does not exist, create one
        salt = os.urandom(16).hex()  # Generate a random 16-byte salt
        hashed_password = hash_password("password123", salt)

        admin_user = User(username="admin", password_hash=hashed_password, salt=salt, name="Admin User", email="admin@example.com")
        db.session.add(admin_user)
        db.session.commit()
        # Print the admin's credentials
        print("\n--- Admin User Credentials ---")
        print(f"Username: {admin_user.username}")
        print(f"Salt: {admin_user.salt}")
        print(f"Salted & Hashed Password: {admin_user.password_hash}")
        print("------------------------------\n")

