from flask import Flask, render_template, request, redirect, url_for, session
from flask_sqlalchemy import SQLAlchemy

app = Flask(__name__)
app.config["SESSION_COOKIE_HTTPONLY"] = True  # Prevent JavaScript access to cookies
app.config["SESSION_COOKIE_SECURE"] = True  # Require cookies to be sent over HTTPS

app.config["SECRET_KEY"] = "supersecretkey"  # Required for cookie signing
app.config["SQLALCHEMY_DATABASE_URI"] = "sqlite:///users.db"
db = SQLAlchemy(app)

# User ORM model
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password = db.Column(db.String, nullable=False)
    name = db.Column(db.String, nullable=False)
    email = db.Column(db.String, unique=True, nullable=False)
    role = db.Column(db.String, nullable=False)  # Role: "admin", "editor", "user"

# Home/Login Page
@app.route("/", methods=["GET"])
def login_get():
    return render_template("login.html", error=None)

# Home/Login Page
@app.route("/", methods=["POST"])
def login_post():
    username = request.form["username"]
    password = request.form["password"]

    user = User.query.filter(User.username==username, User.password==password).first()

    if not user:
        return render_template("login.html", error="Invalid username or password")

    session["user_id"] = user.id  # Store user ID in session
    session["role"] = user.role   # Store role in session
    return redirect(url_for("dashboard"))
        
# Protected Dashboard Route (Role-Based)
@app.route("/dashboard")
def dashboard():
    if "user_id" not in session:
        return redirect(url_for("login_get"))

    current_user = User.query.filter(User.id==session["user_id"]).first()

    if not current_user:
        return redirect(url_for("login_get"))

    if current_user.role == "admin":
        return render_template("admin_dashboard.html", user=current_user)

    if current_user.role == "editor":
        return render_template("editor_dashboard.html", user=current_user)

    return render_template("user_dashboard.html", user=current_user)

# Logout Route
@app.route("/logout")
def logout():
    session.pop("user_id", None)  # Remove session data
    session.pop("role", None)
    return redirect(url_for("login_get"))

app.run(debug=True, reloader_type='stat', port=5000)

