from flask import Flask, render_template, request, redirect, url_for, session
from flask_sqlalchemy import SQLAlchemy

app = Flask(__name__)
app.config["SESSION_COOKIE_HTTPONLY"] = True  # Prevent JavaScript access to cookies
app.config["SESSION_COOKIE_SECURE"] = True  # Require cookies to be sent over HTTPS

app.config["SECRET_KEY"] = "supersecretkey"  # Required for cookie signing
app.config["SQLALCHEMY_DATABASE_URI"] = "sqlite:///users.db"
db = SQLAlchemy(app)

# User ORM model
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password = db.Column(db.String, nullable=False)
    name = db.Column(db.String, nullable=False)
    email = db.Column(db.String, unique=True, nullable=False)
    role = db.Column(db.String, nullable=False)  # Role: "admin", "editor", "user"

# Create database and default users
with app.app_context():
    db.create_all()

    admin_user = User.query.filter_by(username="admin").first()
    editor_user = User.query.filter_by(username="editor").first()
    normal_user = User.query.filter_by(username="user").first()

    if not admin_user:
        admin_user = User(username="admin", password="password123", name="Admin User", email="admin@example.com", role="admin")
        db.session.add(admin_user)

    if not editor_user:
        editor_user = User(username="editor", password="editorpass", name="Editor User", email="editor@example.com", role="editor")
        db.session.add(editor_user)

    if not normal_user:
        normal_user = User(username="user", password="userpass", name="Regular User", email="user@example.com", role="user")
        db.session.add(normal_user)

    db.session.commit()
    print("Default users created: admin / editor / user")
