from flask_wtf import FlaskForm
from wtforms import StringField
from wtforms.validators import DataRequired
from flask import Flask, request, render_template, redirect, abort
from flask_wtf.csrf import CSRFProtect

app = Flask(__name__)
app.config['SECRET_KEY'] = 'supersecretkey'
CSRFProtect(app)

# In-memory list of comments (lost when the app restarts)
comments = []

class CommentForm(FlaskForm):
    comment = StringField('comment', validators=[DataRequired()], render_kw={"placeholder": "Add a public comment..."})

@app.route("/comment", methods=["POST"])
def post_comment():
    form = CommentForm()

    if form.validate_on_submit():
        comments.append(form.comment.data)
    
    return redirect("/")

@app.route("/", methods=["GET"])
def index():
    form = CommentForm()
    return render_template("index.html",  comments=comments, form=form)

app.run(debug=True, reloader_type="stat", port=5000)
