import os
from flask import Flask
from flask_sqlalchemy import SQLAlchemy

db_filename = "users.db"
db_path = f"instance/{db_filename}"

# Delete existing database file
if os.path.exists(db_path):
    os.remove(db_path)  
    print(f"Deleted existing database file: '{db_path}'")

app = Flask(__name__)
app.config["SESSION_COOKIE_HTTPONLY"] = True  # Prevent JavaScript access to cookies
app.config["SESSION_COOKIE_SECURE"] = True  # Require cookies to be sent over HTTPS

app.config["SECRET_KEY"] = "supersecretkey"  # Required for cookie signing
app.config["SQLALCHEMY_DATABASE_URI"] = f"sqlite:///{db_filename}"
db = SQLAlchemy(app)

# User ORM model
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password = db.Column(db.String, nullable=False)  # Hashed password
    name = db.Column(db.String, nullable=False)
    email = db.Column(db.String, unique=True, nullable=False)

# UserPermissions ORM model
class UserPermissions(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    owner_id = db.Column(db.Integer, db.ForeignKey("user.id"), nullable=False)  # The user who owns the data
    granted_user_id = db.Column(db.Integer, db.ForeignKey("user.id"), nullable=False)  # The user who has access


# Create database and default users with hardcoded permission
with app.app_context():
    db.create_all()

    user1 = User(username="user1", password="password1", name="Bob", email="bob@example.com")
    db.session.add(user1)

    user2 = User(username="user2", password="password2", name="Jane", email="jane@example.com")
    db.session.add(user2)

    db.session.commit()

    new_permission = UserPermissions(owner_id=user1.id, granted_user_id=user2.id)
    db.session.add(new_permission)
    db.session.commit()
    print("Permission granted: user2 can view user1's profile.")
