from flask import Flask, request
from werkzeug.middleware.proxy_fix import ProxyFix

app = Flask(__name__)

# Fix HTTP headers so Flask knows it is using HTTPS
app.wsgi_app = ProxyFix(app.wsgi_app, x_proto=1, x_host=1)

@app.route("/")
def home():

    return "This page is secured by flask-talisman. If you can see this you used HTTPS to connect."

app.run(debug=True, reloader_type="stat", port=5000)
