from datetime import datetime

from flask import Flask, render_template, request, redirect, url_for, session
from flask_sqlalchemy import SQLAlchemy


app = Flask(__name__)
app.config["SECRET_KEY"] = "supersecretkey"
app.config["SQLALCHEMY_DATABASE_URI"] = "sqlite:///flixreviews.db"
db = SQLAlchemy(app)


class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password = db.Column(db.String, nullable=False)


class Review(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    movie_title = db.Column(db.String(100), nullable=False)
    movie_year = db.Column(db.Integer, nullable=True)
    reviewer_name = db.Column(db.String(50), nullable=False)
    teaser_line = db.Column(db.String(150), nullable=True)
    rating = db.Column(db.Float, nullable=False)
    review_text = db.Column(db.Text, nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)


@app.route("/")
def home():
    reviews = Review.query.order_by(Review.created_at.desc()).all()
    return render_template("home.html", reviews=reviews)


@app.route("/review/<int:review_id>")
def review_detail(review_id):
    review = Review.query.get_or_404(review_id)
    return render_template("review.html", review=review)


@app.route("/login", methods=["GET"])
def login_get():
    return render_template("login.html", error=None)


@app.route("/login", methods=["POST"])
def login_post():
    username = request.form["username"]
    password = request.form["password"]

    user = User.query.filter(
        User.username == username, User.password == password
    ).first()

    if not user:
        return render_template("login.html", error="Invalid username or password")

    session["user_id"] = user.id
    return redirect(url_for("home"))


# Logout Route
@app.route("/logout")
def logout():
    session.pop("user_id", None)
    return redirect(url_for("login_get"))


# Protected Dashboard Routes
@app.route("/dashboard", methods=["GET"])
def dashboard_get():
    if "user_id" not in session:
        return redirect(url_for("login_post"))

    return render_template("dashboard.html")


@app.route("/dashboard", methods=["POST"])
def dashboard_post():
    if "user_id" not in session:
        return redirect(url_for("login_post"))

    new_review = Review(
        movie_title=request.form["movie_title"],
        movie_year=int(request.form["movie_year"]),
        reviewer_name=request.form["reviewer_name"],
        teaser_line=request.form["teaser_line"],
        rating=float(request.form["rating"]),
        review_text=request.form["review_text"],
        created_at=datetime.utcnow(),
    )
    db.session.add(new_review)
    db.session.commit()

    return redirect(url_for("home"))


app.run(debug=True, reloader_type="stat", port=5000)
