from datetime import datetime
import os

from flask import Flask, render_template, request, redirect, url_for, session
from flask_sqlalchemy import SQLAlchemy

from datetime import datetime

sample_reviews = [
    {
        "movie_title": "The Godfather",
        "movie_year": 1972,
        "reviewer_name": "FilmFanatic99",
        "teaser_line": "A cinematic symphony of crime and family.",
        "rating": 9.5,
        "review_text": "One of the most powerful films ever made. Every scene is iconic.",
        "created_at": datetime(2024, 5, 20)
    },
    {
        "movie_title": "Inception",
        "movie_year": 2010,
        "reviewer_name": "DreamWeaver21",
        "teaser_line": "A dream within a dream, with heart and mind.",
        "rating": 8.7,
        "review_text": "Inception challenges your perception of reality with top-notch visuals.",
        "created_at": datetime(2024, 6, 10)
    },
    {
        "movie_title": "The Dark Knight",
        "movie_year": 2008,
        "reviewer_name": "BatFan",
        "teaser_line": "Heath Ledger redefined villainy.",
        "rating": 9.3,
        "review_text": "Gripping and dark. One of the best superhero films of all time.",
        "created_at": datetime(2024, 4, 5)
    },
    {
        "movie_title": "Parasite",
        "movie_year": 2019,
        "reviewer_name": "CinemaCrush",
        "teaser_line": "Thrilling, funny, tragic — all at once.",
        "rating": 9.0,
        "review_text": "A genre-defying masterpiece about class and deception.",
        "created_at": datetime(2024, 8, 12)
    },
    {
        "movie_title": "La La Land",
        "movie_year": 2016,
        "reviewer_name": "JazzLover88",
        "teaser_line": "A love letter to dreamers.",
        "rating": 8.2,
        "review_text": "Beautifully shot and emotionally resonant, even if bittersweet.",
        "created_at": datetime(2024, 7, 3)
    }
]

db_filename = "flixreviews.db"
db_path = f"instance/{db_filename}"

app = Flask(__name__)
app.config["SECRET_KEY"] = "supersecretkey"  # Required for cookie signing
app.config["SQLALCHEMY_DATABASE_URI"] = f"sqlite:///{db_filename}"
db = SQLAlchemy(app)

class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String, unique=True, nullable=False)
    password = db.Column(db.String, nullable=False)

class Review(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    movie_title = db.Column(db.String(100), nullable=False)
    movie_year = db.Column(db.Integer, nullable=True)
    reviewer_name = db.Column(db.String(50), nullable=False)
    teaser_line = db.Column(db.String(150), nullable=True)
    rating = db.Column(db.Float, nullable=False)
    review_text = db.Column(db.Text, nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)

# Delete existing database file
if os.path.exists(db_path):
    os.remove(db_path)  
    print(f"Deleted existing database file: '{db_path}'")

# Create database and default users
with app.app_context():
    db.create_all()

    admin_user = User(username="admin", password="password123")
    db.session.add(admin_user)

    # Reviews
    for data in sample_reviews:
        review = Review(**data)
        db.session.add(review)
    
    db.session.commit()

    

