from flask import Flask, render_template, url_for, redirect
from flask_sqlalchemy import SQLAlchemy
from flask_security import Security, SQLAlchemyUserDatastore, auth_required
from flask_security.models import fsqla_v3 as fsqla

# Create app and set configuration parameters
app = Flask(__name__)
app.config["DEBUG"] = True
app.config["SECRET_KEY"] = "secretkey"
app.config["SECURITY_PASSWORD_SALT"] = "146585145368132386173505678016728509634"
app.config["SQLALCHEMY_DATABASE_URI"] = "sqlite:///database.db"

# Enable Flask-Security registration
app.config["SECURITY_REGISTERABLE"] = True  # Allows users to register
app.config["SECURITY_SEND_REGISTER_EMAIL"] = False  # Disable email confirmation for now

# Database setup
db = SQLAlchemy(app)  # Create database connection object
fsqla.FsModels.set_db_info(db)  # Define models

# Define models
class Role(db.Model, fsqla.FsRoleMixin):
    pass

class User(db.Model, fsqla.FsUserMixin):
    pass

# Set up Flask-Security
user_datastore = SQLAlchemyUserDatastore(db, User, Role)
security = Security(app, user_datastore)

# Create database tables if they don’t exist
with app.app_context():
    db.create_all()

@app.route("/")
@auth_required()
def dashboard():
    return render_template("dashboard.html")

# Run the app
app.run(debug=True, reloader_type="stat", port=5000)
