from flask import Flask, request, render_template, redirect

app = Flask(__name__)

# In-memory list of comments (lost when the app restarts)
comments = []

@app.route("/comment", methods=["POST"])
def post_comment():
    user_comment = request.form.get("comment", "")
    comments.append(user_comment)
    return redirect("/")

@app.route("/", methods=["GET"])
def index():
    return render_template("index.html", comments=comments)


app.run(debug=True, reloader_type="stat", port=5000)
